<?php
    require_once('./TCPDF-main/tcpdf.php');
    require_once ('./config.php');
    require_once("./phpqrcode/qrlib.php");

    if (isset($_GET['id'])){
        $cn = $_GET['id'];
        
        $get = $link->query("SELECT * FROM shipment_records WHERE id= '$cn'");
        $row = mysqli_fetch_assoc($get);
        
        $tracking_number = $row['awb'];
        $track_json = $row['group'];

        $sender_name = $row['sender'];
        $sender_phone = $row['sender_phone'];
        $sender_state = $row['sender_state'];
        $sender_city = $row['sender_city'];
        $sender_postcode = $row['sender_postcode'];
        $sender_company = $row['sender_company'];
        $sender_add = wordwrap($row['sender_address'],50,' ');

        $receiver_name = $row['receiver'];
        $receiver_phone = $row['receiver_phone'];
        $receiver_company = $row['receiver_company'];
        $receiver_state = $row['receiver_state'];
        $receiver_city = $row['receiver_city'];
        $receiver_postcode = $row['receiver_postcode'];
        $receiver_add = wordwrap($row['receiver_address'],50,' ');

        $weight = $row['charge_weight'];
        $dimen = $row['dimen_weight'];
        $remark="";
        $ttl_weight = 0;
        $content = "";

        if ($track_json != ''){
          $track_arr = json_decode($track_json,true);
        } else {
          $track_arr[] = array();
        }
        

        if ($row['type'] == 'package'){
            $type = 'Package';
        } else {
            $type = 'Document';
        }

        $date = date("d.m.Y",strtotime($row['created_at']));

        if ($weight>$dimen){
            $ttl_weight = $weight;
        } else {
            $ttl_weight = $dimen;
        }        

        $courier_arr = json_decode($row['response'],true);
        $w=$row['weight'];
        $h=$row['height'];
        $l=$row['length'];
        
        $ResponseData = $courier_arr['res']['shipment'];
        
        $sender_add=$sender_add.' '.$sender_city.' '.$sender_postcode.' '.$sender_state;
        $receiver_add=$receiver_add.' '.$receiver_city.' '.$receiver_postcode.' '.$receiver_state;
        $sender_add = str_replace('u0026', "&", $sender_add);
        $receiver_add = str_replace('u0026', "&", $receiver_add);
        
        // $sender_name = str_replace('u0026', "&", $sender_name);
        // $receiver_name = str_replace('u0026', "&", $receiver_name);
        
        // $sender_company = str_replace('u0026', "&", $sender_company);
        // $receiver_company = str_replace('u0026', "&", $receiver_company);
    }

    // Extend the TCPDF class to create custom Header and Footer
    class MYPDF extends TCPDF {

        //Page header
        public function Header() {
            // Logo
            $this->Image('./logo/es.png', 5, 1, 30, '', 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
            // $this->Image('./logo/freshbox.png',37, 0, 30, '', 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
            $this->Image('./logo/abx.png',70, -10, 30, '', 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
        }

        // Page footer
        public function Footer() {
            // Position at 15 mm from bottom
            $this->SetY(-10);
            // Set font
            $this->SetFont('helvetica', 'B', 5);
            // Page number
            $this->Cell(0, 10, 'Terms and Conditions Apply | www.abx.com | www.esparcel.com.my', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        }
    }

    // create new PDF document
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('ES Parcel');
    $pdf->SetTitle('ABX');
    $pdf->SetSubject('ABX AWB');
    $pdf->SetKeywords('TCPDF, PDF, ES Parcel, IO Digital Solution, Courier');

    // set default header data
    $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

    // set margins
    // $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    // $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    // $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $pdf->SetMargins(1, 12, 1);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

    // set auto page breaks
    $pdf->SetAutoPageBreak(TRUE, 0);

    // set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

    // set some language-dependent strings (optional)
    if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
        require_once(dirname(__FILE__).'/lang/eng.php');
        $pdf->setLanguageArray($l);
    }

    // set print header and footer
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);    

    // ---------------------------------------------------------
    
    // set default font subsetting mode
    $pdf->setFontSubsetting(true);
    
    // Set font
    // dejavusans is a UTF-8 Unicode font, if you only need to
    // print standard ASCII chars, you can use core fonts like
    // helvetica or times to reduce file size.
    $pdf->SetFont('dejavusans', 'b', 6, '', true);

    $pdf->AddPage('P', 'A6');
    // Set some content to print
    $params = $pdf->serializeTCPDFtagParameters(array($tracking_number, 'C128', '', '', 30, 10, 0.2, array('position'=>'S', 'border'=>false, 'padding'=>1, 'fgcolor'=>array(0,0,0), 'bgcolor'=>array(255,255,255), 'text'=>false, 'font'=>'helvetica', 'fontsize'=>8, 'stretchtext'=>1), 'N'));    

    $params1 = $pdf->serializeTCPDFtagParameters(array($tracking_number, 'C128', '', '', 95, 20, 0.2, array('position'=>'S', 'border'=>false, 'padding'=>0, 'fgcolor'=>array(0,0,0), 'bgcolor'=>array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>12, 'stretchtext'=>1), 'N'));    

    // $params1 = $pdf->serializeTCPDFtagParameters(array($tracking_number, 'C128', '', '', 80, 30, 0.4, array('position'=>'S', 'border'=>false, 'padding'=>1, 'fgcolor'=>array(0,0,0), 'bgcolor'=>array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>12, 'stretchtext'=>4), 'N'));

    $html = '
        <style>
            td{
            padding:50px;
            }
            
            table {
            width: 100%;
            border-collapse: collapse;
            }

            .bs{
            border: 1px solid black;
            }
        </style>
        <center><tcpdf method="write1DBarcode" params="'.$params1.'" /></center>

        <br>

        <table border="1">

            <tr>
            <td>Shipper Ref : KUA00045 / ES PLATFORM SDN. BHD.</td>
            </tr>

            <tr>
            <td style="text-align:center">Shipper / From</td>
            </tr>

            <tr>
            <td><br>'.$sender_company.'<br>'.$sender_name.'<br>'.$sender_phone.'<br>'.$sender_add.'<br></td>
            </tr>

            <tr>
            <td>Instruction : </td>
            </tr>

            <tr>
            <td style="text-align:center">Consignee / To</td>
            </tr>

            <tr>
            <td><br>'.$receiver_company.'<br>'.$receiver_name.'<br>'.$receiver_phone.'<br>'.$receiver_add.'<br></td>
            </tr>
        </table>

        <table style="border:1px solid black;">
            <tr>
            <td>Date: '.$date.'	</td><td>Origin:	</td><td>Svcs: DEP	</td><td>Destination</td>
            </tr>
            
            <tr>
            <td>No of Pcs: <br>1/1	</td><td>Weight: '.$ttl_weight.'kg	</td><td>Account: KUA00045</td><td></td>
            </tr>
        </table>

        <table>
            <tr><td></td><td></td></tr>
            <tr>
            <td><img src="./logo/abx.png" width="100"></td>
            <td rowspan="2" style="padding: 70px 0;"><u>LIMITATIONS OF LIABILITY</u><br>The Warsaw Convention and other contractual
            exclusions and limitations liability apply.</td>
            </tr>

            <tr>
            <td><img src="./logo/es.png" width="120"></td>
            </tr>
        </table>
    ';
    
    // Print text using writeHTMLCell()
    $pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
    
    // ---------------------------------------------------------
    
    // Close and output PDF document
    // This method has several options, check the source code documentation for more information.
    $pdf->Output($tracking_number.'.pdf', 'I');
?>