<?php
    require_once('./TCPDF-main/tcpdf.php');
    require_once ('./config.php');
    require_once("./phpqrcode/qrlib.php");

    if (isset($_GET['id'])){
        $cn = $_GET['id'];
        
        $get = $link->query("SELECT * FROM shipment_records WHERE id= '$cn'");
        $row = mysqli_fetch_assoc($get);
        
        $tracking_number = $row['awb'];
        $track_json = $row['group'];

        $sender_name = $row['sender'];
        $sender_phone = $row['sender_phone'];
        $sender_state = $row['sender_state'];
        $sender_city = $row['sender_city'];
        $sender_postcode = $row['sender_postcode'];
        $sender_company = $row['sender_company'];
        $sender_add = wordwrap($row['sender_address'],50,' ');

        $receiver_name = $row['receiver'];
        $receiver_phone = $row['receiver_phone'];
        $receiver_company = $row['receiver_company'];
        $receiver_state = $row['receiver_state'];
        $receiver_city = $row['receiver_city'];
        $receiver_postcode = $row['receiver_postcode'];
        $receiver_add = wordwrap($row['receiver_address'],50,' ');

        $weight = $row['charge_weight'];
        $dimen = $row['dimen_weight'];
        $remark="";
        $ttl_weight = 0;
        $content = "";

        if ($track_json != ''){
          $track_arr = json_decode($track_json,true);
        } else {
          $track_arr[] = array();
        }
        

        if ($row['type'] == 'package'){
            $type = 'Package';
        } else {
            $type = 'Document';
        }

        $date = date("d.m.Y",strtotime($row['created_at']));

        if ($weight>$dimen){
            $ttl_weight = $weight;
        } else {
            $ttl_weight = $dimen;
        }        

        $courier_arr = json_decode($row['response'],true);
        $w=$row['weight'];
        $h=$row['height'];
        $l=$row['length'];
        
        $ResponseData = $courier_arr['manifestResponse'];
        
        $sender_add=$sender_add.' '.$sender_city.' '.$sender_postcode.' '.$sender_state;
        $receiver_add=$receiver_add.' '.$receiver_city.' '.$receiver_postcode.' '.$receiver_state;
        $sender_add = str_replace('u0026', "&", $sender_add);
        $receiver_add = str_replace('u0026', "&", $receiver_add);
        
        // $sender_name = str_replace('u0026', "&", $sender_name);
        // $receiver_name = str_replace('u0026', "&", $receiver_name);
        
        // $sender_company = str_replace('u0026', "&", $sender_company);
        // $receiver_company = str_replace('u0026', "&", $receiver_company);
    }

    // Extend the TCPDF class to create custom Header and Footer
    class MYPDF extends TCPDF {

        //Page header
        public function Header() {
            // Logo
            $this->Image('./logo/es.png',3, 3, 35, '', 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
            $this->Image('./logo/dhl.png', 70, 2, 30, '', 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
        }

        // Page footer
        public function Footer() {
            // Position at 15 mm from bottom
            $this->SetY(-15);
            // Set font
            $this->SetFont('helvetica', 'B', 5);
            // Page number
            $this->Cell(0, 10, 'www.esparcel.com.my', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        }
    }

    // create new PDF document
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Nicola Asuni');
    $pdf->SetTitle('DHL AWB');
    $pdf->SetSubject('TCPDF Tutorial');
    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

    // set default header data
    $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

    // set margins
    // $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    // $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    // $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $pdf->SetMargins(1, 10, 5);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

    // set auto page breaks
    $pdf->SetAutoPageBreak(TRUE, 0);

    // set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

    // set some language-dependent strings (optional)
    if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
        require_once(dirname(__FILE__).'/lang/eng.php');
        $pdf->setLanguageArray($l);
    }

    // set print header and footer
    $pdf->setPrintHeader(true);
    $pdf->setPrintFooter(true);    

    // ---------------------------------------------------------
    
    // set default font subsetting mode
    $pdf->setFontSubsetting(true);
    
    // Set font
    // dejavusans is a UTF-8 Unicode font, if you only need to
    // print standard ASCII chars, you can use core fonts like
    // helvetica or times to reduce file size.
    $pdf->SetFont('dejavusans', 'b', 9, '', true);
    
    // Add a page
    // This method has several options, check the source code documentation for more information.
    $pdf->AddPage('P', 'A6');
    
    // set text shadow effect
    // $pdf->setTextShadow(array('enabled'=>true, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

    // Set some content to print
    $params = $pdf->serializeTCPDFtagParameters(array($tracking_number, 'C128', '', '', 18, 8, 0.2, array('position'=>'S', 'border'=>false, 'padding'=>1, 'fgcolor'=>array(0,0,0), 'bgcolor'=>array(255,255,255), 'text'=>false, 'font'=>'helvetica', 'fontsize'=>8, 'stretchtext'=>1), 'N'));    

    $params1 = $pdf->serializeTCPDFtagParameters(array($tracking_number, 'C128', '', '', 50, 20, 0.2, array('position'=>'S', 'border'=>false, 'padding'=>1, 'fgcolor'=>array(0,0,0), 'bgcolor'=>array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>8, 'stretchtext'=>1), 'N'));    

    // $params1 = $pdf->serializeTCPDFtagParameters(array($tracking_number, 'C128', '', '', 80, 30, 0.4, array('position'=>'S', 'border'=>false, 'padding'=>1, 'fgcolor'=>array(0,0,0), 'bgcolor'=>array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>12, 'stretchtext'=>4), 'N'));


    $html = '
    <style>
        .six_box{
            height:12px;
            width:85px;
        }

        .six_box_header{
            height:2px;
            width:85px;
            border: 1px solid black;
        }

        .barcode-box{
          height:15px;
          width:200px;
          text-align:center;
        }

        h4{
            text-align:center;
        }

        .mid_header{
            height:30px;
            border: 1px solid black;
        }

        .row {
          margin-left:-5px;
          margin-right:-5px;
        }
          
        .column {
          float: left;
          width: 30%;
        }
        
        .column1 {
          float: right;
          width: 50%;
        }
        /* Clearfix (clear floats) */
        .row::after {
          content: "";
          clear: both;
          display: table;
        }

        .top_table {
          border-collapse: collapse;
          border-spacing: 0;
          width: 100%;
          border: 1px solid #000;
          height: 70px;
        }

        table {
          border-spacing:0; /* Removes the cell spacing via CSS */ 
          border-collapse: collapse;
        }
    </style>
        <br>
        <!-- top table -->
        <h3 style="align:center"><b>Order ID : '.$ResponseData['bd']['shipmentItems'][0]['shipmentID'].'</b></h3>
        <table border="1" style="margin-bottom:50px">
            <tr>
                <td style="height:30px;text-align:center"><h2>PDO</h2></td>
                <td style="height:30px;text-align:center"><h2>'.$ResponseData['bd']['shipmentItems'][0]['deliveryDepotCode'].'</h2></td>
                <td style="height:30px;text-align:center"><h2>'.$ResponseData['bd']['shipmentItems'][0]['primarySortCode'].'</h2></td>
            </tr>
        </table>
        
      <!-- sender -->
      <table>
        <tr>
            <td rowspan="2" style="text-align:center"><img src="http://www.test.esparcel.com.my/api/qr_generator.php?code='.$tracking_number.'" width="400" height="400" alt=""></td>
            <td class="six_box" width="10px"></td>

            <td colspan="3" >Sender</td>
        </tr>
        <tr>
            <td class="six_box" width="10px"></td>
            <td colspan="3">'.$sender_add.'</td>
        </tr>
        
        <tr>
            <td></td>
            <td class="six_box" width="10px"></td>
            <td style="width:80%">'.$sender_name.'<br>'.$sender_phone.'</td>
        </tr>

        <tr>
          <td colspan="3"><hr></td>
        </tr>
        
      </table>
      <!-- receiver -->
      <table  style="border-collapse: collapse;" width="100%">
          <tr>
              <td colspan="4">Receiver</td>
          </tr>
          <tr>
            <td colspan="4">'.$receiver_add.'</td>
          </tr>
          <Br>
          <tr>
              <td colspan="4">'.$receiver_name.'<br>'.$receiver_phone.'</td>
          </tr>

      </table>
      <br><br><Br>
      <table>
        <tr>
          <td width="80"></td>
          <td><tcpdf method="write1DBarcode" params="'.$params1.'" /></td>
        </tr>
      </table>

      <table border="1" >
            <tr>
                <td style="height:30px;text-align:center"><h2></h2></td>
                <td style="height:30px;text-align:center"><h2></h2></td>
                <td style="height:30px;text-align:center"><h2>'.$ResponseData['bd']['shipmentItems'][0]['secondarySortCode'].'</h2></td>
            </tr>
        </table>
      
    ';
    
    // Print text using writeHTMLCell()
    $pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
    
    // ---------------------------------------------------------
    
    // Close and output PDF document
    // This method has several options, check the source code documentation for more information.
    ob_end_clean();
    $pdf->Output($tracking_number.'.pdf', 'I');
?>