<?php
    require_once('./TCPDF-main/tcpdf.php');
    require_once ('./config.php');
    require_once("./phpqrcode/qrlib.php");

    if (isset($_GET['id'])){
        $cn = $_GET['id'];
        
        $get = $link->query("SELECT * FROM shipment_records WHERE id= '$cn'");
        $row = mysqli_fetch_assoc($get);
        
        $tracking_number = $row['awb'];
        $track_json = $row['group'];

        $sender_name = $row['sender'];
        $sender_phone = $row['sender_phone'];
        $sender_state = $row['sender_state'];
        $sender_city = $row['sender_city'];
        $sender_postcode = $row['sender_postcode'];
        $sender_company = $row['sender_company'];
        $sender_add = wordwrap($row['sender_address'],50,' ');

        $receiver_name = $row['receiver'];
        $receiver_phone = $row['receiver_phone'];
        $receiver_company = $row['receiver_company'];
        $receiver_state = $row['receiver_state'];
        $receiver_city = $row['receiver_city'];
        $receiver_postcode = $row['receiver_postcode'];
        $receiver_add = wordwrap($row['receiver_address'],50,' ');

        $weight = $row['charge_weight'];
        $dimen = $row['dimen_weight'];
        $remark="";
        $ttl_weight = 0;
        $content = "";

        if ($track_json != ''){
          $track_arr = json_decode($track_json,true);
        } else {
          $track_arr[] = array();
        }
        

        if ($row['type'] == 'package'){
            $type = 'Package';
        } else {
            $type = 'Document';
        }

        $date = date("d.m.Y",strtotime($row['created_at']));

        if ($weight>$dimen){
            $ttl_weight = $weight;
        } else {
            $ttl_weight = $dimen;
        }        

        $courier_arr = json_decode($row['response'],true);
        $w=$row['weight'];
        $h=$row['height'];
        $l=$row['length'];
        
        $ResponseData = $courier_arr['ResponseData'];
        

        $sender_add=$sender_add.' '.$sender_city.' '.$sender_postcode.' '.$sender_state;
        $receiver_add=$receiver_add.' '.$receiver_city.' '.$receiver_postcode.' '.$receiver_state;
        $sender_add = str_replace('u0026', "&", $sender_add);
        $receiver_add = str_replace('u0026', "&", $receiver_add);
        
        // $sender_name = str_replace('u0026', "&", $sender_name);
        // $receiver_name = str_replace('u0026', "&", $receiver_name);
        
        // $sender_company = str_replace('u0026', "&", $sender_company);
        // $receiver_company = str_replace('u0026', "&", $receiver_company);
    }

    // Extend the TCPDF class to create custom Header and Footer
    class MYPDF extends TCPDF {

        //Page header
        public function Header() {
            // Logo
            $this->Image('./logo/es.png', 5, 1, 30, '', 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
            $this->Image('./logo/freshbox.png',37, 0, 30, '', 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
            $this->Image('./logo/lineclear.png',70, -10, 30, '', 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
        }

        // Page footer
        public function Footer() {
            // Position at 15 mm from bottom
            $this->SetY(-10);
            // Set font
            $this->SetFont('helvetica', 'B', 5);
            // Page number
            $this->Cell(0, 10, 'Terms and Conditions Apply | www.lineclearexpress.com | www.esparcel.com.my', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        }
    }

    // create new PDF document
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('ES Parcel');
    $pdf->SetTitle('Lineclear');
    $pdf->SetSubject('Lineclear AWB');
    $pdf->SetKeywords('TCPDF, PDF, ES Parcel, IO Digital Solution, Courier');

    // set default header data
    $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

    // set margins
    // $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    // $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    // $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $pdf->SetMargins(1, 12, 1);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

    // set auto page breaks
    $pdf->SetAutoPageBreak(TRUE, 0);

    // set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

    // set some language-dependent strings (optional)
    if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
        require_once(dirname(__FILE__).'/lang/eng.php');
        $pdf->setLanguageArray($l);
    }

    // set print header and footer
    $pdf->setPrintHeader(true);
    $pdf->setPrintFooter(false);    

    // ---------------------------------------------------------
    
    // set default font subsetting mode
    $pdf->setFontSubsetting(true);
    
    // Set font
    // dejavusans is a UTF-8 Unicode font, if you only need to
    // print standard ASCII chars, you can use core fonts like
    // helvetica or times to reduce file size.
    $pdf->SetFont('dejavusans', 'b', 5, '', true);

    $pdf->AddPage('P', 'A6');
    // Set some content to print
    $params = $pdf->serializeTCPDFtagParameters(array($tracking_number, 'C128', '', '', 30, 10, 0.2, array('position'=>'S', 'border'=>false, 'padding'=>1, 'fgcolor'=>array(0,0,0), 'bgcolor'=>array(255,255,255), 'text'=>false, 'font'=>'helvetica', 'fontsize'=>8, 'stretchtext'=>1), 'N'));    

    $params1 = $pdf->serializeTCPDFtagParameters(array($tracking_number, 'C128', '', '', 80, 20, 0.2, array('position'=>'S', 'border'=>false, 'padding'=>1, 'fgcolor'=>array(0,0,0), 'bgcolor'=>array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>12, 'stretchtext'=>1), 'N'));    

    $html = '
        <style>
            .six_box{
                height:15px;
                width:85px;
                text-align:center;
                border-top: none;
                border-left: 1px solid #000;
                border-right: 1px solid #000;
                border-bottom: 1px solid #000;
            }

            .six_box_header{
                height:2px;
                width:85px;
                border-top: 1px solid #000;
                border-left: 1px solid #000;
                border-right: 1px solid #000;
                border-bottom: none;
            }

            .barcode-box{
                height:15px;
                width:200px;
                text-align:center;
            }

            h4{
                text-align:center;
            }

            .mid_header{
                height:30px;
                border: 1px solid black;
            }

            .row {
                margin-left:-5px;
                margin-right:-5px;
            }
                
            .column {
                float: left;
                width: 30%;
            }
            
            .column1 {
                float: right;
                width: 50%;
            }
            /* Clearfix (clear floats) */
            .row::after {
                content: "";
                clear: both;
                display: table;
            }

            .top_table {
                border-collapse: collapse;
                border-spacing: 0;
                width: 100%;
                border: 1px solid #000;
                height: 70px;
            }

            table {
                border-spacing:0; /* Removes the cell spacing via CSS */ 
                border-collapse: collapse;
            }

            p{
                font-size:5px;
            }

            h2{
                font-size:15px;
            }
        </style>

        <table>
        <tr>
            <td class="six_box_header"><p> PCS &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  &nbsp;  &nbsp;M</p></td>
            <td width="10px"></td>
            <td class="six_box_header"><p> Origin Partner</p></td>
            <td class="six_box_header"><p> Origin Depot</p></td>
            <td class="six_box_header"><p> Origin Hub</p></td>
        </tr>

        <tr>
            <td class="six_box"><h2>1/1</h2></td>
            <td width="10px"></td>
            <td class="six_box"><h2>'.$ResponseData[0]['PickupRouteCode'].'</h2></td>
            <td class="six_box"><h2>'.$ResponseData[0]['PickupBranchCode'].'</h2></td>
            <td class="six_box"><h2>'.$ResponseData[0]['PickupHubCode'].'</h2></td>
        </tr>

        <tr>
            <td rowspan="2"  border="1"></td>
            <td width="10px"></td>
            <td class="six_box_header"><p> Origin Partner</p></td>
            <td class="six_box_header"><p> Origin Depot</p></td>
            <td class="six_box_header"><p> Origin Hub</p></td>
        </tr>
        <tr>
            <td width="10px"></td>
            <td class="six_box" rowspan="2"><h2>'.$ResponseData[0]['DeliveryHubCode'].'</h2></td>
            <td class="six_box" rowspan="2"><h2>'.$ResponseData[0]['DeliveryBranchCode'].'</h2></td>
            <td class="six_box" rowspan="2"><h2>'.$ResponseData[0]['DeliveryRouteCode'].'</h2></td>
        </tr>

        <tr>
            <td class="six_box" border="1"></td>
            <td width="10px"></td>
        </tr>

        <tr>
            <td></td>
        </tr>
        </table>
        <!-- sender -->
        <table>
        <tr>
            <!--<td rowspan="2" colspan="2" style="line-height:0;"><img src="http://www.test.esparcel.com.my/api/qr_generator.php?code='.$tracking_number.'" width="100" height="100" alt=""></td>-->
            <td rowspan="2" colspan="2" style="line-height:0;text-align:center"><img src="https://chart.apis.google.com/chart?cht=qr&chs=150x150&chld=L|0&chl='.$tracking_number.'" width="75" height="75" alt=""></td>
            <td colspan="3" >Sender &nbsp; &nbsp; &nbsp; &nbsp;  Account: C9110492000</td>
        </tr>
        <tr>
            <td colspan="2" style="font-family:Arial;font-size: 6;font-weight: bold;">'.$sender_add.'</td>
        </tr>
        
        <tr>
            <td colspan="2"><tcpdf method="write1DBarcode" params="'.$params.'" /></td>
            <td style="width:60%" ><hr>'.$sender_company.'<br>'.$sender_name.'<br>'.$sender_phone.'</td>
        </tr>
        
        </table>
        <hr>
        <!-- receiver -->
        <table  style="border-collapse: collapse;" width="100%">
            <tr>
                <td colspan="4">Receiver &nbsp; &nbsp; &nbsp; &nbsp; Cust Ref:</td>
                <td colspan="4" style="background-color:black;text-align:center"><h3 style="color:white;">Standard Delivery</h3></td>
            </tr>
            <tr>
            <td colspan="4" rowspan="6" style="font-family:Arial;font-size: 6;font-weight: bold;">'.$receiver_add.'<br><hr>'.$receiver_company.'<br>'.$receiver_name.'<br>'.$receiver_phone.'</td>
            <td border="1">W (cm)</td>
            <td border="1">H (cm)</td>
            <td border="1">L (cm)</td>
            <td border="1">KG</td>
            </tr>
            <tr>
            <td border="1">'.$w.'</td>
            <td border="1">'.$h.'</td>
            <td border="1">'.$l.'</td>
            <td border="1">'.$ttl_weight.'</td>
            </tr>

            <tr>
                <td border="1" colspan="2">Type</td>
                <td border="1" colspan="2">'.$type.'</td>
            </tr>

            <tr>
                <td border="1" colspan="2">Content</td>
                <td border="1" colspan="2"></td>
            </tr>
            <tr>
                <td border="1" rowspan="2" colspan="2">Date</td>
                <td border="1" rowspan="2" colspan="2">'.$date.'</td>
            </tr>
            
            <tr>
                <td colspan="4"></td>
            </tr>

            <tr>
                <td colspan="4"></td>
                <td border="1" rowspan="2" colspan="2">Remark</td>
                <td border="1" rowspan="2" colspan="2">'.$remark.'</td>
            </tr>

            <tr>
                <td colspan="4"></td>
            </tr>

        </table>

        <table style="border: 1px solid black;
        border-collapse: collapse;">
            <tr>
                <td style="width:50%">POD</td>
                <td style="width:50%"></td>
            </tr>

            <tr>
                <td style="width:50%">Name:<br></td>
                <td style="width:50%"></td>
            </tr>

            <tr>
                <td style="width:50%">Phone:<br></td>
                <td style="width:50%"></td>
            </tr>

            <tr>
                <td style="width:50%">IC/Passport:<br></td>
                <td style="width:50%; border-top: 1px solid #000;text-align:center;">SIGN/CO. STAMP</td>
            </tr>
        </table>
        
        <!---<table>
            <tr>
                <td></td>
                <td colspan="10" border="1" > POD<br><br> Name:<br><br> Phone:<br><br> IC/Passport:<br></td>
            </tr>
            <tr>
                <td colspan="6"></td>
                <td colspan="4" style="text-align:center;">SIGN/CO. STAMP</td>
            </tr>
        </table>--->
        <br><br>
        <table>
        <tr>
            <td width="30"></td>
            <td><tcpdf method="write1DBarcode" params="'.$params1.'" /></td>
        </tr>
        </table>
    ';
      
    // Print text using writeHTMLCell()
    $pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

    if (sizeof($track_arr)>1){
        foreach($track_arr as $item){
            if($item != $tracking_number){
                $get = $link->query("SELECT * FROM shipment_records WHERE awb= '$item'");
                $row = mysqli_fetch_assoc($get);
                
                $tracking_number = $row['awb'];
                $track_json = $row['group'];

                $sender_name = $row['sender'];
                $sender_phone = $row['sender_phone'];
                $sender_state = $row['sender_state'];
                $sender_city = $row['sender_city'];
                $sender_postcode = $row['sender_postcode'];
                $sender_company = $row['sender_company'];
                $sender_add = wordwrap($row['sender_address'],50,' ');

                $receiver_name = $row['receiver'];
                $receiver_phone = $row['receiver_phone'];
                $receiver_company = $row['receiver_company'];
                $receiver_state = $row['receiver_state'];
                $receiver_city = $row['receiver_city'];
                $receiver_postcode = $row['receiver_postcode'];
                $receiver_add = wordwrap($row['receiver_address'],50,' ');

                $weight = $row['charge_weight'];
                $dimen = $row['dimen_weight'];
                $remark="";
                $ttl_weight = 0;
                $content = "";                

                if ($row['type'] == 'package'){
                    $type = 'Package';
                } else {
                    $type = 'Document';
                }

                $date = date("d.m.Y",strtotime($row['created_at']));

                if ($weight>$dimen){
                    $ttl_weight = $weight;
                } else {
                    $ttl_weight = $dimen;
                }        

                $courier_arr = json_decode($row['response'],true);
                $w=$row['weight'];
                $h=$row['height'];
                $l=$row['length'];
                
                $ResponseData = $courier_arr['ResponseData'];
                
                $sender_add = str_replace('u0026', "&", $sender_add);
                $receiver_add = str_replace('u0026', "&", $receiver_add);
                
                // $sender_name = str_replace('u0026', "&", $sender_name);
                // $receiver_name = str_replace('u0026', "&", $receiver_name);
                
                // $sender_company = str_replace('u0026', "&", $sender_company);
                // $receiver_company = str_replace('u0026', "&", $receiver_company);.
                

                $pdf->AddPage('P', 'A6');
                // Set some content to print
                $params = $pdf->serializeTCPDFtagParameters(array($item, 'C128', '', '', 30, 10, 0.2, array('position'=>'S', 'border'=>false, 'padding'=>1, 'fgcolor'=>array(0,0,0), 'bgcolor'=>array(255,255,255), 'text'=>false, 'font'=>'helvetica', 'fontsize'=>8, 'stretchtext'=>1), 'N'));    

                $params1 = $pdf->serializeTCPDFtagParameters(array($item, 'C128', '', '', 80, 20, 0.2, array('position'=>'S', 'border'=>false, 'padding'=>1, 'fgcolor'=>array(0,0,0), 'bgcolor'=>array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>12, 'stretchtext'=>1), 'N'));    

                $html = '
                    <style>
                        .six_box{
                            height:15px;
                            width:85px;
                            text-align:center;
                            border-top: none;
                            border-left: 1px solid #000;
                            border-right: 1px solid #000;
                            border-bottom: 1px solid #000;
                        }

                        .six_box_header{
                            height:2px;
                            width:85px;
                            border-top: 1px solid #000;
                            border-left: 1px solid #000;
                            border-right: 1px solid #000;
                            border-bottom: none;
                        }

                        .barcode-box{
                            height:15px;
                            width:200px;
                            text-align:center;
                        }

                        h4{
                            text-align:center;
                        }

                        .mid_header{
                            height:30px;
                            border: 1px solid black;
                        }

                        .row {
                            margin-left:-5px;
                            margin-right:-5px;
                        }
                            
                        .column {
                            float: left;
                            width: 30%;
                        }
                        
                        .column1 {
                            float: right;
                            width: 50%;
                        }
                        /* Clearfix (clear floats) */
                        .row::after {
                            content: "";
                            clear: both;
                            display: table;
                        }

                        .top_table {
                            border-collapse: collapse;
                            border-spacing: 0;
                            width: 100%;
                            border: 1px solid #000;
                            height: 70px;
                        }

                        table {
                            border-spacing:0; /* Removes the cell spacing via CSS */ 
                            border-collapse: collapse;
                        }

                        p{
                            font-size:5px;
                        }

                        h2{
                            font-size:15px;
                        }
                    </style>

                    <table>
                    <tr>
                        <td class="six_box_header"><p> PCS &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  &nbsp;  &nbsp;M</p></td>
                        <td width="10px"></td>
                        <td class="six_box_header"><p> Origin Partner</p></td>
                        <td class="six_box_header"><p> Origin Depot</p></td>
                        <td class="six_box_header"><p> Origin Hub</p></td>
                    </tr>

                    <tr>
                        <td class="six_box"><h2>1/1</h2></td>
                        <td width="10px"></td>
                        <td class="six_box"><h2>'.$ResponseData[0]['PickupRouteCode'].'</h2></td>
                        <td class="six_box"><h2>'.$ResponseData[0]['PickupBranchCode'].'</h2></td>
                        <td class="six_box"><h2>'.$ResponseData[0]['PickupHubCode'].'</h2></td>
                    </tr>

                    <tr>
                        <td rowspan="2"  border="1"></td>
                        <td width="10px"></td>
                        <td class="six_box_header"><p> Origin Partner</p></td>
                        <td class="six_box_header"><p> Origin Depot</p></td>
                        <td class="six_box_header"><p> Origin Hub</p></td>
                    </tr>
                    <tr>
                        <td width="10px"></td>
                        <td class="six_box" rowspan="2"><h2>'.$ResponseData[0]['DeliveryHubCode'].'</h2></td>
                        <td class="six_box" rowspan="2"><h2>'.$ResponseData[0]['DeliveryBranchCode'].'</h2></td>
                        <td class="six_box" rowspan="2"><h2>'.$ResponseData[0]['DeliveryRouteCode'].'</h2></td>
                    </tr>

                    <tr>
                        <td class="six_box" border="1"></td>
                        <td width="10px"></td>
                    </tr>

                    <tr>
                        <td></td>
                    </tr>
                    </table>
                    <!-- sender -->
                    <table>
                    <tr>
                        <!--<td rowspan="2" colspan="2" style="line-height:0;"><img src="http://www.test.esparcel.com.my/api/qr_generator.php?code='.$item.'" width="100" height="100" alt=""></td>-->
                        <td rowspan="2" colspan="2" style="line-height:0;text-align:center"><img src="https://chart.apis.google.com/chart?cht=qr&chs=150x150&chld=L|0&chl='.$item.'" width="75" height="75" alt=""></td>
                        <td colspan="3" >Sender &nbsp; &nbsp; &nbsp; &nbsp;  Account: C9110492000</td>
                    </tr>
                    <tr>
                        <td colspan="2" style="font-family:Arial;font-size: 6;font-weight: bold;">'.$sender_add.'</td>
                    </tr>
                    
                    <tr>
                        <td colspan="2"><tcpdf method="write1DBarcode" params="'.$params.'" /></td>
                        <td style="width:60%" ><hr>'.$sender_company.'<br>'.$sender_name.'<br>'.$sender_phone.'</td>
                    </tr>
                    
                    </table>
                    <hr>
                    <!-- receiver -->
                    <table  style="border-collapse: collapse;" width="100%">
                        <tr>
                            <td colspan="4">Receiver &nbsp; &nbsp; &nbsp; &nbsp; Cust Ref:</td>
                            <td colspan="4" style="background-color:black;text-align:center"><h3 style="color:white;">Standard Delivery</h3></td>
                        </tr>
                        <tr>
                        <td colspan="4" rowspan="6" style="font-family:Arial;font-size: 6;font-weight: bold;">'.$receiver_add.'<br><hr>'.$receiver_company.'<br>'.$receiver_name.'<br>'.$receiver_phone.'</td>
                        <td border="1">W (cm)</td>
                        <td border="1">H (cm)</td>
                        <td border="1">L (cm)</td>
                        <td border="1">KG</td>
                        </tr>
                        <tr>
                        <td border="1">'.$w.'</td>
                        <td border="1">'.$h.'</td>
                        <td border="1">'.$l.'</td>
                        <td border="1">'.$ttl_weight.'</td>
                        </tr>

                        <tr>
                            <td border="1" colspan="2">Type</td>
                            <td border="1" colspan="2">'.$type.'</td>
                        </tr>

                        <tr>
                            <td border="1" colspan="2">Content</td>
                            <td border="1" colspan="2"></td>
                        </tr>
                        <tr>
                            <td border="1" rowspan="2" colspan="2">Date</td>
                            <td border="1" rowspan="2" colspan="2">'.$date.'</td>
                        </tr>
                        
                        <tr>
                            <td colspan="4"></td>
                        </tr>

                        <tr>
                            <td colspan="4"></td>
                            <td border="1" rowspan="2" colspan="2">Remark</td>
                            <td border="1" rowspan="2" colspan="2">'.$remark.'</td>
                        </tr>

                        <tr>
                            <td colspan="4"></td>
                        </tr>

                    </table>

                    <table style="border: 1px solid black;
                    border-collapse: collapse;">
                        <tr>
                            <td style="width:50%">POD</td>
                            <td style="width:50%"></td>
                        </tr>

                        <tr>
                            <td style="width:50%">Name:<br></td>
                            <td style="width:50%"></td>
                        </tr>

                        <tr>
                            <td style="width:50%">Phone:<br></td>
                            <td style="width:50%"></td>
                        </tr>

                        <tr>
                            <td style="width:50%">IC/Passport:<br></td>
                            <td style="width:50%; border-top: 1px solid #000;text-align:center;">SIGN/CO. STAMP</td>
                        </tr>
                    </table>
                    
                    <!---<table>
                        <tr>
                            <td></td>
                            <td colspan="10" border="1" > POD<br><br> Name:<br><br> Phone:<br><br> IC/Passport:<br></td>
                        </tr>
                        <tr>
                            <td colspan="6"></td>
                            <td colspan="4" style="text-align:center;">SIGN/CO. STAMP</td>
                        </tr>
                    </table>--->
                    <br><br>
                    <table>
                    <tr>
                        <td width="30"></td>
                        <td><tcpdf method="write1DBarcode" params="'.$params1.'" /></td>
                    </tr>
                    </table>
                ';
                
                // Print text using writeHTMLCell()
                $pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

            }
        }
    }
    
    // ---------------------------------------------------------
    
    // Close and output PDF document
    // This method has several options, check the source code documentation for more information.
    $pdf->Output($tracking_number.'.pdf', 'I');
?>