<?php
    require_once('./TCPDF-main/tcpdf.php');
    require_once ('./config.php');
    require_once("./phpqrcode/qrlib.php");

    if (isset($_GET['id'])){
        $cn = $_GET['id'];
        
        $get = $link->query("SELECT * FROM shipment_records WHERE id= '$cn'");
        $row = mysqli_fetch_assoc($get);
        
        $tracking_number = $row['awb'];
        $track_json = $row['group'];

        $sender_name = $row['sender'];
        $sender_phone = $row['sender_phone'];
        $sender_state = $row['sender_state'];
        $sender_city = $row['sender_city'];
        $sender_postcode = $row['sender_postcode'];
        $sender_company = $row['sender_company'];
        $sender_add = wordwrap($row['sender_address'],50,' ');

        $receiver_name = $row['receiver'];
        $receiver_phone = $row['receiver_phone'];
        $receiver_company = $row['receiver_company'];
        $receiver_state = $row['receiver_state'];
        $receiver_city = $row['receiver_city'];
        $receiver_postcode = $row['receiver_postcode'];
        $receiver_add = wordwrap($row['receiver_address'],50,' ');

        $weight = $row['charge_weight'];
        $dimen = $row['dimen_weight'];
        $remark="";
        $ttl_weight = 0;
        $content = "";

        if ($track_json != ''){
          $track_arr = json_decode($track_json,true);
        } else {
          $track_arr[] = array();
        }
        

        if ($row['type'] == 'package'){
            $type = 'Package';
        } else {
            $type = 'Document';
        }

        $date = date("d.m.Y",strtotime($row['created_at']));

        if ($weight>$dimen){
            $ttl_weight = $weight;
        } else {
            $ttl_weight = $dimen;
        }        

        $courier_arr = json_decode($row['response'],true);
        $w=$row['weight'];
        $h=$row['height'];
        $l=$row['length'];
        
        // $ResponseData = $courier_arr['ResponseData'];
        $route=$courier_arr['route'];
        
        $sender_add=$sender_add.' '.$sender_city.' '.$sender_postcode.' '.$sender_state;
        $receiver_add=$receiver_add.' '.$receiver_city.' '.$receiver_postcode.' '.$receiver_state;
        $sender_add = str_replace('u0026', "&", $sender_add);
        $receiver_add = str_replace('u0026', "&", $receiver_add);
        $barcode_url ='https://barcode.tec-it.com/barcode.ashx?data='.$tracking_number.'&code=Code128&translate-esc=on';

        $connote_date = date("dmY",strtotime($row['created_at']));

        $qr_str="A2^$tracking_number^$connote_date^MY^80000000^$sender_name^$sender_phone^^$sender_postcode^^8800555567^$receiver_name^^$receiver_add^$receiver_city^$receiver_postcode^$receiver_city^$receiver_state^$receiver_phone^^$weight^".$h."X".$w."X".$l."^^^^^^";
        
        // $sender_name = str_replace('u0026', "&", $sender_name);
        // $receiver_name = str_replace('u0026', "&", $receiver_name);
        
        // $sender_company = str_replace('u0026', "&", $sender_company);
        // $receiver_company = str_replace('u0026', "&", $receiver_company);
    }

    // Extend the TCPDF class to create custom Header and Footer
    class MYPDF extends TCPDF {

        //Page header
        public function Header() {
            // Logo
            $this->Image('./logo/es.png',1, 4, 26, '', 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
            $this->Image('./logo/poslaju.png', 28, 4, 26, '', 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
            
            $this->Image($barcode_url,57, 3, 45, '', 'JPG', '', '', false, 300, '', false, false, 0, false, false, false);
        }

        // Page footer
        public function Footer() {
            // Position at 15 mm from bottom
            $this->SetY(-10);
            // Set font
            $this->SetFont('helvetica', 'B', 5);
            // Page number
            $this->Cell(0, 10, 'Terms and Conditions Apply | www.lineclearexpress.com | www.esparcel.com.my', 0, false, 'C', 0, '', 0, false, 'T', 'M');
        }
    }

    // create new PDF document
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Nicola Asuni');
    $pdf->SetTitle('PosLaju');
    $pdf->SetSubject('TCPDF Tutorial');
    $pdf->SetKeywords('TCPDF, PDF, example, test, guide');

    // set default header data
    $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

    // set margins
    // $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    // $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    // $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $pdf->SetMargins(1, 5, 1);
    // $pdf->SetMargins(1, 25, 1);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

    // set auto page breaks
    $pdf->SetAutoPageBreak(TRUE, 0);

    // set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

    // set some language-dependent strings (optional)
    if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
        require_once(dirname(__FILE__).'/lang/eng.php');
        $pdf->setLanguageArray($l);
    }

    // set print header and footer
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);    

    // ---------------------------------------------------------
    
    // set default font subsetting mode
    $pdf->setFontSubsetting(true);
    
    // Set font
    // dejavusans is a UTF-8 Unicode font, if you only need to
    // print standard ASCII chars, you can use core fonts like
    // helvetica or times to reduce file size.
    $pdf->SetFont('dejavusans', 'b', 5, '', true);

    if (sizeof($track_arr)>1){
    } else {
      $pdf->AddPage('P', 'A6');
      // Set some content to print
      $params = $pdf->serializeTCPDFtagParameters(array($tracking_number, 'C128', '', '', 30, 10, 0.2, array('position'=>'S', 'border'=>false, 'padding'=>1, 'fgcolor'=>array(0,0,0), 'bgcolor'=>array(255,255,255), 'text'=>false, 'font'=>'helvetica', 'fontsize'=>8, 'stretchtext'=>1), 'N'));    

      $params1 = $pdf->serializeTCPDFtagParameters(array($tracking_number, 'C128', '', '', 50, 20, 0.2, array('position'=>'S', 'border'=>false, 'padding'=>1, 'fgcolor'=>array(0,0,0), 'bgcolor'=>array(255,255,255), 'text'=>true, 'font'=>'helvetica', 'fontsize'=>12, 'stretchtext'=>1), 'N'));    

      $html = '
        <style>
            td.f6.5{
                font-family:Arial;
                font-size: 6.5;
                font-weight: bold;
            }

          td.f5{
            font-family:Arial;
            font-size: 5;
            font-weight: bold;
          }

          td.f8{
            font-family:Arial;
            font-size: 7;
            font-weight: bold;
          }

          td.f23{
            font-family:Arial;
            font-size: 23;
            font-weight: bold;
          }

          td.f10{
            font-family:Arial;
            font-size: 10;
            font-weight: bold;
          }

          td.f18{
            font-family:Arial;
            font-size: 18;
            font-weight: bold;
          }

          span.f12{
            font-family:Arial;
            font-size: 12;
            font-weight: bold;
          }
        </style>
        <table>
          <tr>
            <td style="vertical-align: middle;"><img width="80" height="40" src="./logo/poslaju.png">&nbsp;&nbsp;<img width="90" height="40" src="./logo/es.png"></td>
            <td><tcpdf method="write1DBarcode" params="'.$params1.'" /></td>
          </tr>
          <tr>
            <th class="f5">MAKLUMAT ITEM:</th>
            
            <th class="f5">RUJ.TRANSAKSI:</th>
          </tr>
          <tr>
            <td class="f5">Tarikh : '.date("d M Y",strtotime($date)).'</td>
            <td class="f5">Produk : COURIER CHARGES - DOMESTIC</td>
          </tr>

          <tr>
            <td class="f5">Berat : '.$weight.' KG</td>
            <td class="f5">Jenis : Package</td>
          </tr>

          <tr>
            <td class="f5">Sebenar : '.$ttl_weight.' KG</td>
            <td class="f5">Keterangan : Package</td>
          </tr>

          <tr>
            <td class="f5">Volumetrik : '.$dimen.' KG</td>
            <td class="f5">Insurance : <br>Type: '.ucfirst($type).'</td>
          </tr>

          <tr>
            <td colspan="2" align="center" class="f23">'.$route.'</td>
          </tr>
          <tr>
            <td colspan="2" align="center" class="f10">A GOM</td>
          </tr>

          <tr>
            <td class="f6.5">DARIPADA:</td>
            <td class="f6.5">AKAUN NO: 8800555567</td>
          </tr>

          <tr>
            <td class="f8">'.$sender_company.'<br>'.$sender_name.'<br>'.$sender_add.' '.$sender_postcode.' '.$sender_city.'<br>Tel: '.$sender_phone.' &nbsp;&nbsp;&nbsp;&nbsp; RUJ.PENGIRIM:</td>
            <td class="f5"></td>
          </tr>

          <hr>

          <tr>
            <td class="f6.5">KEPADA:&nbsp;&nbsp;&nbsp;&nbsp;RUJ.PENERIMA:</td>
            <td align="right"></td>
          </tr>

          <tr>
            <td class="f8">'.$receiver_name.'<br>'.$receiver_company.'<br>'.$receiver_add.'<br>Tel: '.$receiver_phone.'</td>
            <td align="right"><img src="http://www.test.esparcel.com.my/api/qr_generator.php?code='.rawurlencode($qr_str).'" width="100" height="100" alt=""></td>
          </tr>

          <tr>
            <td>POSKOD: <span class="f12">*'.$tracking_number.'*</span></td>
            <td align="right" class="f18">'.$receiver_postcode.'</td>
          </tr>

          <tr>
            <td class="f5">'.$receiver_name.'<br>'.$receiver_company.'<br>'.$receiver_add.' '.$receiver_postcode.' '.$receiver_city.'<br>Tel: '.$receiver_phone.'</td>
            <td align="right"><tcpdf method="write1DBarcode" params="'.$params1.'" /></td>
          </tr>
        </table>';
      
      // Print text using writeHTMLCell()
      $pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
    }
    
    // ---------------------------------------------------------
    
    // Close and output PDF document
    // This method has several options, check the source code documentation for more information.
    $pdf->Output($tracking_number.'.pdf', 'I');
?>